<?php

class Media_Mobile_Api_Music_AlbumController extends Application_Controller_Mobile_Default {


    public function _toJson($album){
        $json = array(
            "id" => $album->getId(),
            "name" => $album->getName(),
            "artworkUrl" => $album->getArtworkUrl(),
            "artistName" => $album->getArtistName(),
            "totalDuration" => $album->getTotalDuration(),
            "totalTracks" => $album->getTotalTracks(),
            "type" => $album->getType()
        );

        return $json;
    }

    public function findAction() {

        if($value_id = $this->getRequest()->getParam('value_id')
           && $album_id = $this->getRequest()->getParam('album_id')) {

            try {

                $elements = new Media_Model_Gallery_Music_Elements();
                $element = $elements->find($album_id, "album_id");

                if($element->getAlbumId()) {

                    $album = new Media_Model_Gallery_Music_Album();
                    $album->find($element->getAlbumId());

                    $data = array("album" => $this->_toJson($album));
                } else {
                    $data = array('error' => 1, 'message' => $this->_("This element is not an album."));
                }
            }
            catch(Exception $e) {
                $data = array('error' => 1, 'message' => $e->getMessage());
            }

        } else {
            $data = array('error' => 1, 'message' => $this->_("An error occurred while loading. Please try again later."));
        }

        $this->_sendHtml($data);

    }

    public function findallAction() {

        if($value_id = $this->getRequest()->getParam('value_id')) {

            try {

                $playlists = new Media_Model_Gallery_Music();
                $playlists = $playlists->findAll(array('value_id' => $value_id), 'position ASC');


                $json = array();

                foreach($playlists as $playlist) {

                    $elements = new Media_Model_Gallery_Music_Elements();
                    $elements = $elements->findAll(array('gallery_id' => $playlist->getId()), 'position ASC');

                    foreach($elements as $element) {

                        if($element->getAlbumId()) {

                            $album = new Media_Model_Gallery_Music_Album();
                            $album->find($element->getAlbumId());

                            $json[] = $this->_toJson($album);
                        }

                    }
                }

                $data = array("albums" => $json);


            }
            catch(Exception $e) {
                $data = array('error' => 1, 'message' => $e->getMessage());
            }


        }else{
            $data = array('error' => 1, 'message' => 'An error occurred during process. Please try again later.');
        }
        $this->_sendHtml($data);
    }

    public function findbyplaylistAction() {


        if($value_id = $this->getRequest()->getParam('value_id')
           && $playlist_id = $this->getRequest()->getParam('playlist_id')) {

            try {

                $elements = new Media_Model_Gallery_Music_Elements();
                $elements = $elements->findAll(array('gallery_id' => $playlist_id), 'position ASC');

                $json = array();

                foreach($elements as $element) {


                    if($element->getAlbumId()) {

                        $album = new Media_Model_Gallery_Music_Album();
                        $album->find($element->getAlbumId());

                        $json[] = $this->_toJson($album);
                    }

                }

                $data = array("albums" => $json);


            }
            catch(Exception $e) {
                $data = array('error' => 1, 'message' => $e->getMessage());
            }


        }else{
            $data = array('error' => 1, 'message' => 'An error occurred during process. Please try again later.');
        }
        $this->_sendHtml($data);
    }

}