<?php

class Installer_Backoffice_ModuleController extends Backoffice_Controller_Default
{

    public function loadAction() {

        $html = array(
            "title" => $this->_("Modules"),
            "icon" => "fa-cloud-download",
        );

        $this->_sendHtml($html);

    }

    public function uploadAction() {

        try {

            if(empty($_FILES) || empty($_FILES['file']['name'])) {
                throw new Exception("No file has been sent");
            }

            $adapter = new Zend_File_Transfer_Adapter_Http();
            $adapter->setDestination(Core_Model_Directory::getTmpDirectory(true));

            if($adapter->receive()) {

                $file = $adapter->getFileInfo();

                $parser = new Installer_Model_Installer_Module_Parser();
                $parser->setFile($file['file']['tmp_name'])
                    ->extract()
                ;

                $data = array(
                    "success" => 1,
                    "filename" => base64_encode($file['file']['name'])
                );

            } else {
                $messages = $adapter->getMessages();
                if(!empty($messages)) {
                    $message = implode("\n", $messages);
                } else {
                    $message = $this->_("An error occurred during the process. Please try again later.");
                }

                throw new Exception($message);
            }
        } catch(Exception $e) {
            $data = array(
                "error" => 1,
                "message" => $e->getMessage()
            );
        }

        $this->_sendHtml($data);
    }

    public function copyAction() {

        if($file = $this->getRequest()->getParam("file")) {

            $data = array();

            try {

                $filename = base64_decode($file);
                $file = Core_Model_Directory::getTmpDirectory(true)."/$filename";

                if(!file_exists($file)) {
                    throw new Exception($this->_("The file %s does not exist", $filename));
                }

                $parser = new Installer_Model_Installer_Module_Parser();
                if($parser->setFile($file)->copy()) {

                    $data = array("success" => 1);

                } else {

                    $messages = $parser->getErrors();
                    $message = implode("\n", $messages);

                    throw new Exception($this->_($message));

                }

            } catch(Exception $e) {
                $data = array(
                    "error" => 1,
                    "message" => $e->getMessage()
                );
            }

            $this->_sendHtml($data);
        }

    }

    public function installAction() {

        $data = array();

        try {

            $cache = Zend_Registry::isRegistered('cache') ? Zend_Registry::get('cache') : null;
            if($cache) {
                $cache->clean("all");
            }

            $cache_ids = array('js_mobile.js', 'js_desktop.js', 'css_mobile.css', 'css_desktop.css');
            foreach ($cache_ids as $cache_id) {
                if(file_exists(Core_Model_Directory::getCacheDirectory(true)."/{$cache_id}")) {
                    @unlink(Core_Model_Directory::getCacheDirectory(true)."/{$cache_id}");
                }
            }

            $module_names = Zend_Controller_Front::getInstance()->getDispatcher()->getSortedModuleDirectories();
            $modules = array();
            foreach($module_names as $module_name) {
                $module = new Installer_Model_Installer_Module();
                $module->prepare($module_name);
                if($module->canUpdate()) {
                    $modules[] = $module->getName();
                }
            }

            foreach($modules as $module) {
                $installer = new Installer_Model_Installer();
                $installer->setModuleName($module)
                    ->install()
                ;
            }

            $data = array(
                "success" => 1,
                "message" => $this->_("Module successfully installed")
            );

        } catch(Exception $e) {
            $data = array(
                "error" => 1,
                "message" => $e->getMessage()
            );
        }

        $this->_sendHtml($data);

    }

}
