<?php

class Admin_Model_Admin extends Core_Model_Default
{

    protected $_applications;
    protected $_subaccounts;

    const LOGO_PATH = '/images/admin';

    public function __construct($datas = array()) {
        parent::__construct($datas);
        $this->_db_table = 'Admin_Model_Db_Table_Admin';
    }

    public function findByEmail($email) {
        return $this->find($email, 'email');
    }

    public function getStats() {
        return $this->getTable()->getStats();
    }

    public function save() {

        $countries = Zend_Registry::get('Zend_Locale')->getTranslationList('Territory', null, 2);

        if($this->getCountryCode()) {
            if(empty($countries[$this->getCountryCode()])) {
                throw new Exception($this->_("An error occurred while saving. The country is not valid."));
            } else if($this->getCountry() != $countries[$this->getCountryCode()]) {
                $this->setCountry($countries[$this->getCountryCode()]);
            }
        }

        return parent::save();

    }

    public function getApplications() {

        if(!$this->_applications) {
            $application = new Application_Model_Application();
            $this->_applications = $application->findAllByAdmin($this->getId());
        }

        return $this->_applications;

    }

    public function isAllowedToAddPages($app_id) {
        return (bool) $this->getTable()->isAllowedToAddPages($this->getId(), $app_id);
    }

    public function getSubaccounts() {

        if(!$this->_subaccounts) {
            $subaccount = new self();
            $this->_subaccounts = $subaccount->findAll(array('parent_id' => $this->getId()));
        }

        return $this->_subaccounts;

    }

    public function canOrder() {
        return !is_null($this->getFirstname()) &&
            !is_null($this->getLastname()) &&
            !is_null($this->getCompany()) &&
            !is_null($this->getAddress()) &&
            !is_null($this->getCountry()) &&
            !is_null($this->getPhone());
    }

    public function setPassword($password) {
        if(strlen($password) < 6) throw new Exception($this->_('The password must be at least 6 characters'));
        $this->setData('password', $this->_encrypt($password));
        return $this;
    }

    public function isSamePassword($password) {
        return $this->getPassword() == $this->_encrypt($password);
    }

    public function authenticate($password) {
        return $this->_checkPassword($password);
    }

    public static function getLogoPathTo($path = '') {
        return Core_Model_Directory::getPathTo(self::LOGO_PATH.$path);
    }

    public static function getBaseLogoPathTo($path = '') {
        return Core_Model_Directory::getBasePathTo(self::LOGO_PATH.$path);
    }

    public static function getNoLogo($base = false) {
        return $base ? self::getBaseLogoPathTo('placeholder/no-logo.png') : self::getLogoPathTo('placeholder/no-logo.png');
    }

    public function getLogoLink() {
        if($this->getData('logo') AND is_file(self::getBaseLogoPathTo($this->getData('logo')))) {
            return self::getLogoPath($this->getData('logo'));
        }
        else {
            return self::getNoLogo();
        }

    }

    public function getLogoUrl() {
        return $this->getBaseUrl().$this->getLogoLink();
    }

    public function getBaseLogoLink() {
        if($this->getData('logo') AND is_file(self::getBaseLogoPathTo($this->getLogo()))) return self::getBaseLogoPathTo($this->getLogo());
        else return self::getNoLogo(true);
    }

    private function _encrypt($password) {
        return sha1($password);
    }

    private function _checkPassword($password) {
        return $this->getPassword() == $this->_encrypt($password);
    }

}