"use strict";

App.filter('duration', function () {
    return function (duration) {
        if (duration && !isNaN(duration)) {
            var totalSeconds = duration / 1000;
            var totalMinutes = totalSeconds / 60;
            var minutes = Math.round(totalMinutes % 60);
            var seconds = Math.round(totalSeconds % 60);
            if (seconds < 10) {
                seconds = '0' + seconds;
            }
            var formatedDuration = minutes + ':' + seconds;
            return formatedDuration;
        }
    };
});