App.factory('Places', function ($rootScope, $http, Url) {

    var factory = {};

    factory.value_id = null;

    factory.find = function (place_id) {

        if (!this.value_id) return;

        return $http({
            method: 'GET',
            url: Url.get("places/mobile_api_places/find", {
                value_id: this.value_id,
                place_id: place_id
            }),
            cache: !$rootScope.isOverview,
            responseType: 'json'
        });
    };

    factory.findAll = function (position) {

        if (!this.value_id) return;

        var parameters = {
            value_id: this.value_id
        };

        if (position && position.coords) {
            parameters.latitude = position.coords.latitude;
            parameters.longitude = position.coords.longitude;
        }

        return $http({
            method: 'GET',
            url: Url.get("places/mobile_api_places/findall", parameters),
            cache: !$rootScope.isOverview,
            responseType: 'json'
        });
    };

    return factory;
});