App.controller('HomeController', function ($window, $scope, $timeout, Application, Pages, Customer, Push) {

    $scope.$watch("isOnline", function (isOnline) {
        $scope.has_connection = isOnline;
        $scope.loadContent();
    });

    $scope.tabbar_is_visible = Pages.is_loaded == true;
    $scope.animate_tabbar = !$scope.tabbar_is_visible;
    $scope.pages_list_is_visible = false;
    $scope.options = new Array();
    $scope.limited_options = new Array();
    $scope.close_on_click = Application.is_previewer;

    $scope.loadContent = function () {

        Pages.findAll().success(function (data) {

            if(Application.is_ios) {
                Application.call({appIsLoaded: null});
            }

            $timeout(function () {
                Pages.is_loaded = true;
                $scope.tabbar_is_visible = true;
            }, 200);

            $scope.options = data.pages;
            $scope.customer_account = data.customer_account;
            $scope.more_items = data.more_items;
            $scope.limit_to = data.limit_to - 1;
            $scope.layout_id = data.layout_id;

            $scope.prepareTabbar();

            //angular.forEach($scope.options, function(option) {
            //    if(option.code == "push_notification") {
            //        Push.value_id = option.value_id;
            //        Push.count().success(function(data) {
            //            console.log(data);
            //        });
            //    }
            //
            //});

            //Push.count().success(function() {
            //    angular.forEach($scope.options, function(v, k) {
            //        console.log(v);
            //        console.log(k);
            //    });
            //});

        });
    };

    $scope.prepareTabbar = function () {

        $scope.limited_options = new Array();
        $scope.filtered_options = new Array();

        for (var i = 0; i < $scope.options.length; i++) {
            if (!$scope.options[i].is_locked || Customer.can_access_locked_features) {
                if (!Customer.isLoggedIn() || $scope.options[i].code != "padlock") {
                    $scope.filtered_options.push($scope.options[i]);
                }
            }
        }

        if ($scope.limit_to > 0 && $scope.filtered_options.length > $scope.limit_to) {
            for (var i = 0; i < $scope.limit_to; i++) {
                $scope.limited_options.push($scope.filtered_options[i]);
            }

            $scope.more_items.is_visible = true;
        } else {
            $scope.limited_options = $scope.filtered_options;
            $scope.more_items.is_visible = false;
        }

        $scope.customer_account.url = Customer.isLoggedIn() ? $scope.customer_account.edit_url : $scope.customer_account.login_url;

        // filter active options
        $scope.filtered_active_options = $scope.filtered_options.reduce(function (options, option) {
            if (option.is_active) {
                options.push(option);
            }
            return options;
        }, []);

        if ($scope.layout_id === 'l8') {

            var main_option = null;
            var groups = [];

            if ($scope.filtered_active_options.length !== 0) {

                main_option = $scope.filtered_active_options[0];

                var options = $scope.filtered_active_options.slice(1);

                if ($scope.customer_account.is_visible) {
                    options.push($scope.customer_account);
                }


                for (var i = 0; i < options.length; i++) {

                    var index = i % 13;

                    switch (index) {
                    case 0:
                    case 2:
                    case 5:
                    case 7:
                    case 10:
                        // new line
                        groups.push([]);
                    default:
                        break;
                    }

                    groups[groups.length - 1].push(options[i]);
                }
            }

            $scope.main_option = main_option;
            $scope.options_groups = groups;

        }
    };

    //    if($scope.isOverview) {
    //        Overview.scope = $scope;
    //        Overview.prepare();
    //    }

    $scope.reload = function () {
        $scope.tabbar_is_visible = false;
        Pages.is_loaded = false;
    }

});

//App.factory("Overview", function($window, $route, $timeout, $templateCache, $injector, httpCache) {
//
//    var factory = {};
//    factory.scope = null;
//
//    factory.prepare = function() {
//
//        $window.changeLayout = function() {
//            $injector.get("Pages").is_loaded = false;
//            $templateCache.remove(BASE_URL+"/front/mobile_home/view");
//            httpCache.remove(BASE_URL+'/front/mobile_home/findall');
//            $route.reload();
//        }
//
//        this.scope.$on("$destroy", function() {
//            $window.changeLayout = null;
//        });
//    }
//
//    return factory;
//});