<?php

class Media_Mobile_Api_Music_TrackController extends Application_Controller_Mobile_Default {


    public function _toJson($track){
        $json = array(
            "id" => $track->getId(),
            "name" => $track->getName(),
            "artistName" => $track->getArtistName(),
            "duration" => $track->getDuration(),
            "streamUrl" => $track->getStreamUrl(),
            "purchaseUrl" => $track->getPurchaseUrl()
        );

        if($track->getType() != 'podcast'){
            $json["formatedDuration"] = $track->getFormatedDuration($track->getDuration());
        }else{
            $json["formatedDuration"] = $track->getFormatedDuration();
        }

        return $json;
    }

    public function findbyalbumAction() {

        if($value_id = $this->getRequest()->getParam('value_id') 
           && $album_id = $this->getRequest()->getParam('album_id')) {

            try {

                $album = new Media_Model_Gallery_Music_Album();
                $album->find($album_id);


                $album_tracks = $album->getAllTracks(true);

                $json = array();

                foreach($album_tracks as $track) {
                    $json[] = $this->_toJson($track);
                }

                $data = array("tracks" => $json);


            } catch(Exception $e) {

            }

        }else{
            $data = array('error' => 1, 'message' => 'An error occurred during process. Please try again later.');
        }
        $this->_sendHtml($data);
    }

}