"use strict";

App.factory('MediaMusicAlbum', function ($rootScope, $http, Url) {

    var factory = {};

    factory.value_id = null;

    factory.find = function (album_id) {

        if (!this.value_id) {
            console.error('value_id is not defined.');
            return;
        }
        if (!album_id) {
            console.error('album_id is not defined.');
            return;
        }

        return $http({
            method: 'GET',
            url: Url.get("media/mobile_api_music_album/find", {
                value_id: this.value_id,
                album_id: album_id
            }),
            cache: !$rootScope.isOverview,
            responseType: 'json'
        });
    };
    
    factory.findAll = function() {

        if (!this.value_id) {
            console.error('value_id is not defined.');
            return;
        }

        return $http({
            method: 'GET',
            url: Url.get("media/mobile_api_music_album/findall", {value_id: this.value_id,}),
            cache: !$rootScope.isOverview,
            responseType:'json'
        });
    };

    factory.findByPlaylist = function (playlist_id) {

        if (!this.value_id) {
            console.error('value_id is not defined.');
            return;
        }
        if (!playlist_id) {
            console.error('playlist_id is not defined.');
            return;
        }
        return $http({
            method: 'GET',
            url: Url.get("media/mobile_api_music_album/findbyplaylist", {
                value_id: this.value_id,
                playlist_id: playlist_id
            }),
            cache: !$rootScope.isOverview,
            responseType: 'json'
        });
    };

    return factory;
});