App.config(function($routeProvider) {

    $routeProvider.when(BASE_URL+"/installer/backoffice_module", {
        controller: 'ModuleController',
        templateUrl: BASE_URL+"/installer/backoffice_module/template"
    });

}).controller("ModuleController", function($scope, $interval, Header, Installer, Url, Label, FileUploader) {

    $scope.header = new Header();
    $scope.header.button.left.is_visible = false;
    $scope.header.loader_is_visible = false;
    $scope.content_loader_is_visible = true;

    $scope.checking_module = false;
    $scope.installation_progress = 0;

    $scope.installation = {
        copy: {
            is_visible: false,
            process: 0,
            interval_id: null,
            running: false,
            success: false,
            error: false
        },
        install: {
            is_visible: false,
            process: 0,
            interval_id: null,
            running: false,
            success: false,
            error: false
        }
    };

    $scope.uploader = new FileUploader({
        url: Url.get("installer/backoffice_module/upload")
    });

    $scope.uploader.filters.push({
        name: 'limit',
        fn: function(item, options) {
            return this.queue.length < 1;
        }
    });

    //$scope.uploader.filters.push({
    //    name: 'zip_only',
    //    fn: function(item, options) {
    //        return item.type == "application/zip" || item.type == "application/octet-stream";
    //    }
    //});

    Installer.loadData().success(function(data) {
        $scope.header.title = data.title;
        $scope.header.icon = data.icon;
    }).finally(function() {
        $scope.content_loader_is_visible = false;
    });

    $scope.uploader.onWhenAddingFileFailed = function(item, filter, options) {
        if(filter.name == "zip_only") $scope.message.setText(Label.uploader.error.type.zip).isError(true).show();
        if(filter.name == "limit") $scope.message.setText(Label.uploader.error.only_one_at_a_time).isError(true).show();
    };

    $scope.uploader.onSuccessItem = function(fileItem, response, status, headers) {

        if(angular.isObject(response) && response.success) {

            $scope.showModuleInstallation();
            $scope.installation.copy.filename = response.filename;
            $scope.copyModule();

        } else {
            $scope.message.setText(Label.uploader.error.general)
                .isError(true)
                .show()
            ;
        }
    };
    $scope.uploader.onErrorItem = function(fileItem, response, status, headers) {

        $scope.message.setText(response.message)
            .isError(true)
            .show()
        ;
    };



    $scope.increaseProgressBar = function(state) {
        $scope.installation[state].progress += 5;
    };

    $scope.copyModule = function() {

        if(!$scope.installation.copy.filename) {
            $scope.message.setText("An error occurred while trying to install the module. Please, reload the page and try again.")
                .isError(true)
                .show()
            ;
            return;
        }

        var filename = $scope.installation.copy.filename;

        $scope.installation.copy.progress = 0;
        $scope.installation.copy.success = false;
        $scope.installation.copy.error = false;
        $scope.installation.copy.running = true;

        $scope.installation.copy.interval_id = $interval(function() {
            $scope.increaseProgressBar("copy");
        }, 500, 18);

        Installer.copy(filename).success(function(data) {

            if(angular.isObject(data) && data.success) {

                $scope.installation.copy.success = true;
                $scope.installModule();

            } else {
                $scope.message.setText(Label.uploader.error.general)
                    .isError(true)
                    .show()
                ;

                $scope.installation.copy.error = true;

            }

        }).error(function(data) {

            $scope.message.setText(data.message)
                .isError(true)
                .show()
            ;

            $scope.installation.copy.error = true;

        }).finally(function() {
            $interval.cancel($scope.installation.copy.interval_id);
            $scope.installation.copy.running = false;
            $scope.installation.copy.progress = 100;
        });

    };

    $scope.installModule = function() {

        $scope.installation.install.is_visible = true;
        $scope.installation.install.progress = 0;
        $scope.installation.install.success = false;
        $scope.installation.install.error = false;
        $scope.installation.install.running = true;

        $scope.installation.install.interval_id = $interval(function() {
            $scope.increaseProgressBar("install");
        }, 500, 18);

        Installer.install().success(function(data) {

            if(angular.isObject(data) && data.success) {
                $scope.message.setText(data.message)
                    .isError(false)
                    .show()
                ;

                $scope.installation.install.success = true;
            } else {
                $scope.message.setText(Label.uploader.error.general)
                    .isError(true)
                    .show()
                ;

                $scope.installation.install.error = true;

            }

        }).error(function(data) {

            $scope.message.setText(data.message)
                .isError(true)
                .show()
            ;

            $scope.installation.install.error = true;

        }).finally(function() {
            $interval.cancel($scope.installation.install.interval_id);
            $scope.installation.install.running = false;
            $scope.installation.install.progress = 100;
        });

    };

    $scope.showModuleInstallation = function() {
        $scope.installation.copy.is_visible = true;
    };

    $scope.toggleLoader = function() {
        $scope.header.loader_is_visible = !$scope.header.loader_is_visible;
    }


});
